<?php
/**
 * @file
 * Settings page callback file for the counter module.
 */

/**
 * Menu callback.
 */
function counter_admin_settings() {
  $form = array();

  // Generate the form - settings applying to all patterns first.
  $form['counter_settings'] = array(
    '#type' => 'fieldset',
    '#weight' => -30,
    '#title' => t('Basic settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['counter_settings']['counter_show_site_counter'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show Online Counter'),
    '#default_value' => variable_get('counter_show_site_counter', 1),
  );


  $form['counter_statistic'] = array(
    '#type' => 'fieldset',
    '#weight' => -20,
    '#title' => t('Statistic settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['counter_statistic']['counter_statistic_today'] = array(
    '#type' => 'checkbox',
    '#title' => t('Visitors Today'),
    '#default_value' => variable_get('counter_statistic_today', 1),
  );
  
  $form['counter_statistic']['counter_statistic_week'] = array(
    '#type' => 'checkbox',
    '#title' => t('Visitors This Week'),
    '#default_value' => variable_get('counter_statistic_week', 1),
  );
  $form['counter_statistic']['counter_statistic_month'] = array(
    '#type' => 'checkbox',
    '#title' => t('Visitors This Month'),
    '#default_value' => variable_get('counter_statistic_month', 1),
  );
  $form['counter_statistic']['counter_statistic_year'] = array(
    '#type' => 'checkbox',
    '#title' => t('Visitors This Year'),
    '#default_value' => variable_get('counter_statistic_year', 1),
  );

  return system_settings_form($form);
}

/**
 * Implements hook_settings_advanced().
 */
function counter_settings_advanced() {
  $form['counter_advanced'] = array(
    '#type' => 'fieldset',
    '#weight' => -20,
    '#title' => t('Advanced settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['counter_advanced']['counter_skip_admin'] = array(
    '#type' => 'checkbox',
    '#title' => t('Skip admin'),
    '#default_value' => variable_get('counter_skip_admin', 0),
    '#description' => t("Do not count when visitor is admin (uid=1)."),
  );

  $form['counter_advanced']['counter_refresh_delay'] = array(
    '#type' => 'textfield',
    '#title' => t('Delay before refresh counter data (in second)'),
    '#default_value' => variable_get('counter_refresh_delay', 10),
    '#description' => t("Delay before re-calculate counter data, otherwise read from previous value."),
  );

  $form['counter_advanced']['counter_insert_delay'] = array(
    '#type' => 'textfield',
    '#title' => t('Delay before next insert (in second)'),
    '#default_value' => variable_get('counter_insert_delay', 1),
    '#description' => t("Wait for certain second before next insert. Increase this value if your server can not handle too much data recording. Set to 0 for no delay."),
  );

  return system_settings_form($form);
}

/**
 * Implements hook_initial().
 */
function counter_settings_initial() {
  $form['counter_initial'] = array(
    '#type' => 'fieldset',
    '#weight' => -10,
    '#title' => t('Initial Values'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#description' => t("Set initial values for Site Counter."),
  );

  $form['counter_initial']['counter_initial_counter'] = array(
    '#type' => 'textfield',
    '#title' => t('Initial Value set for Total visitor '),
    '#default_value' => variable_get('counter_initial_counter', 0),
    '#description' => t('Initial value of Site Counter'),
  );

   $form['counter_initial']['counter_initial_week'] = array(
    '#type' => 'textfield',
    '#title' => t('Initial Value set for Week'),
    '#default_value' => variable_get('counter_initial_week', 0),
    '#description' => t('Initial value of Week Counter'),
  );
  
    $form['counter_initial']['counter_initial_month'] = array(
    '#type' => 'textfield',
    '#title' => t('Initial Value set for Month  '),
    '#default_value' => variable_get('counter_initial_month', 0),
    '#description' => t('Initial value of Month Counter'),
  );
  
  $form['counter_initial']['counter_initial_year'] = array(
    '#type' => 'textfield',
    '#title' => t('Initial Value set for Year  '),
    '#default_value' => variable_get('counter_initial_year', 0),
    '#description' => t('Initial value of Year Counter'),
  );

  $form['counter_initial']['counter_initial_since'] = array(
    '#type' => 'textfield',
    '#title' => t("Replace 'Since' value with this Unix timestamp"),
    '#default_value' => variable_get('counter_initial_since', 0),
    '#description' => t("If you leave this field blank then Counter module will use data from first inserted row of Counter table. This field type is Unix timestamp, so you must enter like: 1404671462."),
  );

  return system_settings_form($form);
}
