***
***

## <a name="contribution"></a>SUBMITTING PATCHES OR ISSUES
Please consider the following to help you explain better, and to help us
understand better your bug reports, or patches as needed:

1. [Issue summaries](https://www.drupal.org/issue-summaries)

2. [Issue template](https://www.drupal.org/node/1326662)

* If you hate formalism, consider a crystal clear line, or two in the body text.
* Avoid explaining everything in the title.
* Use body text for explanation purposes.
* If language is a barrier, use any available/ online translation tool.

### SUBMITTING ISSUES
When submitting bug reports, please:

* be kind with proper reproduction, and enough details.  
* mention library version, related-module version, if any, active theme, or
  anything which may help us identify issue better.  
* ensure the library is loaded, not 404.  
* switch to stock Bartik for just in case it is your custom theme.  
* use matching or similar branches or tags for related modules.  
* check out dups.  
* file it a support request, if unsure. We'll mark a bug a bug even if you
  file it under support requests.  

### SUBMITTING PATCHES
We consider a patch as help, they consider it a sale, so thank you in advanced!
In order for you to help, or buy, us successfully, please consider:

* communicating and filling out the body text with proper explanations, not in
  comments (unless for comment patches, of course).
  I've seen patches which broke a module, so explanation is a must.
  If you have no time to write it in the body text, please hold off till later!
* providing optional links to the change records, or docs, if any.
* providing links to docs is a must for coding standards issues.
  This also lets us, you and me, learn from the actual docs, not told by tools!
  We can just run `drupalcs ...`, but help is welcome, too, in case a miss.
* checking out the latest dev branch in case already resolved.
* providing reproduction steps for bug reports is a must. No repro, no bugs.

You must speak like human to human, and help us respect you, and your time.
Dumping patches with empty body text will be disregarded, till the above is met.

Thank you for your kind consideration, cooperation, and contribution!

## BUG REPORTS OR SUPPORT REQUESTS
A basic knowledge of Drupal site building is required. If you get stuck:

   * consult the provided READMEs via **/admin/help**,
   * consult descriptions on each form item,
   * consult the relevant guidelines from the supported modules,
   * consider the project issue queues, your problem may be already addressed,
   * install **slick_example**.

If you do have bug reports, we love bugs, please:

   * provide steps to reproduce it, valid bugs must have consistent
     reproduction,
   * provide detailed info, a screenshot of the output and Slick form, or words
     to identify it any better, library version, module version, active theme.
   * make sure that the bug is caused by the module.

For the Slick library bug, please report it to:
  [Slick library](https://github.com/kenwheeler/slick)

You can create a fiddle to isolate the bug if reproduceable outside the module:
  [Fiddle](http://jsfiddle.net/)

For the support requests, a screenshot of the output and Slick form are helpful.
Shortly, you should kindly help the maintainers with detailed info to help you.
Thanks.
