<?php
/**
 * @file
 * Theme functions for Views Slideshow JCarousel
 */

/**
 * Theme pager fields
 */
function _views_slideshow_jcarousel_preprocess_pager(&$vars) {
  // Render all the fields unless there is only 1 slide and the user specified
  // to hide them when there is only one slide.
  $vars['rendered_field_items'] = '';
  if (empty($vars['settings']['hide_on_single_slide']) || count($vars['view']->result) > 1) {
    // Build our javascript settings.
    $js_vars = array(
      'viewsSlideshowJCarouselPager' => array(
        $vars['vss_id'] => array(
          $vars['location'] => array(
            'carouselObj' => '',
            'moveOnChange' => $vars['settings']['views_slideshow_jcarousel_pager_move_on_change'],
  					'updateOnPrevNext' => $vars['settings']['views_slideshow_jcarousel_pager_update_on_prev_next'],
            'orientation' => $vars['settings']['views_slideshow_jcarousel_pager_orientation'],
            'scroll' => $vars['settings']['views_slideshow_jcarousel_pager_scroll'],
            'visible' => $vars['settings']['views_slideshow_jcarousel_pager_visible'],
            'wrap' => $vars['settings']['views_slideshow_jcarousel_pager_wrap'],
            'animation' => $vars['settings']['views_slideshow_jcarousel_pager_animation'],
          ),
        ),
      ),
    );

    // Add the settings to the page.
    drupal_add_js($js_vars, array('type' => 'setting', 'scope' => JS_DEFAULT));

    // Add our class to the wrapper.
    $vars['attributes_array']['class'][] = 'views_slideshow_jcarousel_pager';
    $vars['attributes_array']['class'][] = 'jcarousel-skin-' . $vars['settings']['views_slideshow_jcarousel_pager_skin'];
    $vars['attributes_array']['id'] = 'widget_pager_' . $vars['location'] . '_' . $vars['vss_id'];

    foreach ($vars['view']->result as $count => $node) {
      $rendered_fields = '';
      foreach ($vars['settings']['views_slideshow_jcarousel_pager_fields'] as $field => $use) {
        if ($use !== 0 && is_object($vars['view']->field[$field])) {
          $rendered_fields .= theme('views_slideshow_jcarousel_pager_field', array('view' => $vars['view'], 'field' => $field, 'count' => $count));
        }
      }
      $vars['rendered_field_items'] .= theme('views_slideshow_jcarousel_pager_item', array('vss_id' => $vars['vss_id'], 'item' => $rendered_fields, 'count' => $count, 'location' => $vars['location']));
    }

    if (module_exists('libraries')) {
      // Load jCarousel
      if ($jcarousel_path = _views_slideshow_jcarousel_library_path()) {
        drupal_add_js($jcarousel_path);
      }

      $jcarousel_path = libraries_get_path('jcarousel');
      drupal_add_css($jcarousel_path . '/skins/' . $vars['settings']['views_slideshow_jcarousel_pager_skin'] . '/skin.css');
      // Load our jcarousel pager js
      $module_path = drupal_get_path('module', 'views_slideshow_jcarousel');
      drupal_add_js($module_path . '/js/views_slideshow_jcarousel.js');
    }
  }
}

/**
 * Views Slideshow jCarousel: pager item.
 *
 * @ingroup themeable
 */
function _views_slideshow_jcarousel_preprocess_pager_item(&$vars) {
  $current = $vars['count'] + 1;
  $classes = array(
    'views_slideshow_jcarousel_pager_item',
  );
  if (!$vars['count']) {
    $classes[] = 'views_slideshow_active_pager_field_item';
  }
  $classes[] = ($vars['count'] % 2) ? 'views-row-even' : 'views-row-odd';

  $vars['attributes_array']['class'] = $classes;
  $vars['attributes_array']['id'] = 'views_slideshow_jcarousel_pager_item_' . $vars['location'] . '_' . $vars['vss_id'] . '_' . $vars['count'];
}
